/*global Module*/
"use strict";

import React from 'react';
import Select from 'react-select';

const genders = [
    { value: 'empty', label: ' ' },
    { value: 'man', label: 'Mężczyzna' },
    { value: 'woman', label: 'Kobieta' }
];

const hands = [
    { value: 'empty', label: ' ' },
    { value: 'left', label: 'Lewa' },
    { value: 'right', label: 'Prawa' },
    { value: 'both', label: 'Obie' }
];

const currentYear = new Date().getFullYear();

const years = [];
years.push({value: 'empty', label: ' '})
    
for (let i = 0; i < 50; i += 1) {
    years.push({ value: currentYear - i, label: currentYear - i });
}

const hours = [];
hours.push({value: 'empty', label: ' '})
    
for (let i = 0; i < 16.5; i += 0.5) {
    hours.push({ value: i, label: i });
}

const hours_week = [];
hours_week.push({value: 'empty', label: ' '})
    
for (let i = 0; i < 26; i += 1) {
    hours_week.push({ value: i, label: i });
}

const years_num = [];
years_num.push({value: 'empty', label: ' '})
    
for (let i = 0; i < 31; i += 1) {
    years_num.push({ value: i, label: i });
}

const language_num = [];
language_num.push({value: 'empty', label: ' '})
    
for (let i = 0; i < 11; i += 1) {
    language_num.push({ value: i, label: i });
}

const percent_num = [];
percent_num.push({value: 'empty', label: ' '})
    
for (let i = 0; i < 101; i += 10) {
    percent_num.push({ value: i, label: i });
}

const likert = [];
likert.push({value: 'empty', label: ' '})
likert.push({value: 'definetely_not', label: 'zdecydowanie się nie zgadzam'})
likert.push({value: 'rather_not', label: 'raczej się nie zgadzam'})
likert.push({value: 'undecided', label: 'trudno powiedzieć'})
likert.push({value: 'rather_yes', label: 'raczej się zgadzam'})
likert.push({value: 'definetely_yes', label: 'zdecydowanie się zgadzam'})

const yes_no = [];
yes_no.push({value: 'empty', label: ' '});
yes_no.push({value: 'yes', label: 'tak'});
yes_no.push({value: 'no', label: 'nie'});

const musical_level = [];
musical_level.push({value: 'empty', label: ' '});
musical_level.push({value: 'amateur', label: 'amatorsko'});
musical_level.push({value: 'proffesional', label: 'profesjonalnie'});
musical_level.push({value: 'none', label: 'wcale'});

const sports = [];
sports.push({value: 'empty', label: ' '});
sports.push({value: 'none', label: 'nie uprawiam sportu'});
sports.push({value: 'cardio', label: 'wytrzymałościowy'});
sports.push({value: 'strength', label: 'siłowy'});
sports.push({value: 'intellectual', label: 'intelektualny'});
sports.push({value: 'combination', label: 'jakaś kombinacja powyższych'});

const styles = {
    header: {
        display: 'table',
        width: '100%',
        height: '20px'
    },
    row: {
        display: 'table',
        width: '100%',
        tableLayout: 'fixed'
    },
    desc: {
        display: 'table-cell',
        textAlign: 'right',
        fontFamily: "'Fira Mono', Monaco, 'Andale Mono', 'Lucida Console', 'Bitstream Vera Sans Mono', 'Courier New', Courier, monospace", 
        webkitUserSelect : 'none', 
        mozUserSelect: 'none', 
        msUserSelect: 'none', 
        userSelect: 'none'
    },
    ind: {
        display: 'table-cell',
        width: '20px',
        webkitUserSelect : 'none', 
        mozUserSelect: 'none', 
        msUserSelect: 'none', 
        userSelect: 'none'
    },
    select: {
        fontFamily: "'Fira Mono', Monaco, 'Andale Mono', 'Lucida Console', 'Bitstream Vera Sans Mono', 'Courier New', Courier, monospace"
    }
}

/**
 * Component for adding user parameters
 */
class ParmViewer extends React.Component {
    /**
     * Basic constructor.
     * @param {any} props properties of Component
     */
    constructor(props) {
        super(props);
        this.props = props;
        this.state = {};
    }

     
    render() {
        
        return (
            <div>
                <div style={styles.header}/>
                <div className='age' style={styles.row}>
                    <span htmlFor="age" style={styles.desc}>Rok urodzenia</span>
                    <Select 
                        options={years}
                        onChange={this.props.handleChangeYear}
                        placeholder={'Wybierz rok urodzenia'}
                        display={'table-cell'}
                        height={'20px'} 
                        styles={styles.select}
                        noValidate
                    />
                    <div style={styles.ind}/>
                </div>
                <div className='gender' style={styles.row}>
                    <span htmlFor="gender" style={styles.desc}>Płeć</span>
                    <Select
                        options={genders}
                        onChange={this.props.handleChangeGender}
                        placeholder='Wybierz płeć'
                        display={'table-cell'}
                        height={'20px'}
                        styles={styles.select}
                        noValidate
                    />
                    <div style={styles.ind}/>
                </div>
                    <div className='hand' style={styles.row}>
                    <span htmlFor="hand" style={styles.desc}>Dominująca ręka</span>
                    <Select
                        options={hands}
                        onChange={this.props.handleChangeHand}
                        placeholder='Wybierz dominującą rękę'
                        display={'table-cell'}
                        height={'20px'}
                        styles={styles.select}
                        noValidate
                    />
                    <div style={styles.ind}/>
                </div>                
                <div className='sleep_hours' style={styles.row}>
                    <span htmlFor="sleep_hours" style={styles.desc}>Średnia liczba godzin snu</span>
                    <Select 
                        options={hours}
                        onChange={this.props.handleChangeSleepHours}
                        placeholder={'Wybierz średnią liczbę godzin snu'}
                        display={'table-cell'}
                        height={'20px'} 
                        styles={styles.select}
                        noValidate
                    />
                    <div style={styles.ind}/>
                </div>
                <div className='sleep_hours_today' style={styles.row}>
                    <span htmlFor="sleep_hours_today" style={styles.desc}>Liczba godzin snu dzisiaj</span>
                    <Select 
                        options={hours}
                        onChange={this.props.handleChangeSleepHoursToday}
                        placeholder={'Wybierz liczbę godzin snu dzisiejszej nocy'}
                        display={'table-cell'}
                        height={'20px'} 
                        styles={styles.select}
                        noValidate
                    />
                    <div style={styles.ind}/>
                </div>
                <div className='years_game_playing' style={styles.row}>
                    <span htmlFor="years_game_playing" style={styles.desc}>Liczba lat grania w gry komputerowe</span>
                    <Select 
                        options={years_num}
                        onChange={this.props.handleChangeYearsGamePlaying}
                        placeholder={'Wybierz liczbę lat grania w gry komputerowe'}
                        display={'table-cell'}
                        height={'20px'} 
                        styles={styles.select}
                        noValidate
                    />
                    <div style={styles.ind}/>
                </div>
                <div className='hours_game_playing' style={styles.row}>
                    <span htmlFor="hours_game_playing" style={styles.desc}>Średnio godzin grania w gry komputerowe na dobę</span>
                    <Select 
                        options={hours}
                        onChange={this.props.handleChangeHoursGamePlaying}
                        placeholder={'Wybierz średnią liczbę godzin grania w gry komputerowe na dobę'}
                        display={'table-cell'}
                        height={'20px'} 
                        styles={styles.select}
                        noValidate
                    />
                    <div style={styles.ind}/>
                </div>
                <div className='musical_experience' style={styles.row}>
                    <span htmlFor="musical_experience" style={styles.desc}>Gram na instrumencie lub śpiewam: poziom</span>
                    <Select 
                        options={musical_level}
                        onChange={this.props.handleChangeMusicalExperience}
                        placeholder={'Wybierz na jakim poziomie grasz na instrumencie lub śpiewasz'}
                        display={'table-cell'}
                        height={'20px'} 
                        styles={styles.select}
                        noValidate
                    />
                    <div style={styles.ind}/>
                </div>
                <div className='musical_duration' style={styles.row}>
                    <span htmlFor="musical_duration" style={styles.desc}>Gram na instrumencie lub śpiewam: liczba lat</span>
                    <Select 
                        options= {years_num}
                        onChange={this.props.handleChangeMusicalDuration}
                        placeholder={'Wybierz ile lat grasz na instrumencie lub śpiewasz'}
                        display={'table-cell'}
                        height={'20px'} 
                        styles={styles.select}
                        noValidate
                    />
                    <div style={styles.ind}/>
                </div>
                <div className='languages' style={styles.row}>
                    <span htmlFor="languages" style={styles.desc}>Liczba języków obcych</span>
                    <Select 
                        options= {language_num}
                        onChange={this.props.handleChangeLanguages}
                        placeholder={'Wybierz ilu języków obcych się uczysz/uczyłeś/uczyłaś'}
                        display={'table-cell'}
                        height={'20px'} 
                        styles={styles.select}
                        noValidate
                    />
                    <div style={styles.ind}/>
                </div>
                <div className='sport_years' style={styles.row}>
                    <span htmlFor="sport_years" style={styles.desc}>Liczba lat treningu sportowego</span>
                    <Select 
                        options= {years_num}
                        onChange={this.props.handleChangeSportYears}
                        placeholder={'Wybierz od ilu lat uprawiasz sport'}
                        display={'table-cell'}
                        height={'20px'} 
                        styles={styles.select}
                        noValidate
                    />
                    <div style={styles.ind}/>
                </div>
                <div className='sport_hours' style={styles.row}>
                    <span htmlFor="sport_hours" style={styles.desc}>Liczba godzin treningu sportowego tygodniowo</span>
                    <Select 
                        options= {hours_week}
                        onChange={this.props.handleChangeSportHours}
                        placeholder={'Wybierz ile godzin tygodniowo uprawiasz sport'}
                        display={'table-cell'}
                        height={'20px'} 
                        styles={styles.select}
                        noValidate
                    />
                    <div style={styles.ind}/>
                </div>
                <div className='strength_percent' style={styles.row}>
                    <span htmlFor="strength_percent" style={styles.desc}>Procent komponentu siłowego w aktywności sportowej</span>
                    <Select 
                        options= {percent_num}
                        onChange={this.props.handleChangeStrengthPercent}
                        placeholder={'Wybierz ile procent twojej aktywności stanowi komponent siłowy'}
                        display={'table-cell'}
                        height={'20px'} 
                        styles={styles.select}
                        noValidate
                    />
                    <div style={styles.ind}/>
                </div>
                <div className='cardio_percent' style={styles.row}>
                    <span htmlFor="cardio_percent" style={styles.desc}>Procent komponentu wytrzymałościowego w aktywności sportowej</span>
                    <Select 
                        options= {percent_num}
                        onChange={this.props.handleChangeCardioPercent}
                        placeholder={'Wybierz ile procent twojej aktywności stanowi komponent wytrzymałościowy'}
                        display={'table-cell'}
                        height={'20px'} 
                        styles={styles.select}
                        noValidate
                    />
                    <div style={styles.ind}/>
                </div>
                    <div className='intellect_percent' style={styles.row}>
                    <span htmlFor="intellect_percent" style={styles.desc}>Procent komponentu intelektualnego w aktywności sportowej</span>
                    <Select 
                        options= {percent_num}
                        onChange={this.props.handleChangeIntellectPercent}
                        placeholder={'Wybierz ile procent twojej aktywności stanowi komponent intelektualny'}
                        display={'table-cell'}
                        height={'20px'} 
                        styles={styles.select}
                        noValidate
                    />
                    <div style={styles.ind}/>
                </div>
                <div className='cons' style={styles.row}>
                    <span htmlFor="cons" style={styles.desc}>Uważam się za osobę sumienną</span>
                    <Select 
                        options= {likert}
                        onChange={this.props.handleChangeCons}
                        placeholder={'Wybierz na ile zgadzasz się ze zdaniem po lewej'}
                        display={'table-cell'}
                        height={'20px'} 
                        styles={styles.select}
                        noValidate
                    />
                    <div style={styles.ind}/>
                </div>
                <div className='calculations' style={styles.row}>
                    <span htmlFor="calculations" style={styles.desc}>Uważam, że sprawnie wykonuję obliczenia w pamięci</span>
                    <Select 
                        options= {likert}
                        onChange={this.props.handleChangeCalculations}
                        placeholder={'Wybierz na ile zgadzasz się ze zdaniem po lewej'}
                        display={'table-cell'}
                        height={'20px'} 
                        styles={styles.select}
                        noValidate
                    />
                    <div style={styles.ind}/>
                </div>
                <div className='navigation' style={styles.row}>
                    <span htmlFor="navigation" style={styles.desc}>Uważam, że sprawnie posługuję się mapą/nawigacją i dobrze orientuję się w terenie</span>
                    <Select 
                        options= {likert}
                        onChange={this.props.handleChangeNavigation}
                        placeholder={'Wybierz na ile zgadzasz się ze zdaniem po lewej'}
                        display={'table-cell'}
                        height={'20px'} 
                        styles={styles.select}
                        noValidate
                    />
                    <div style={styles.ind}/>
                </div>
            </div>
        );
    }
}                   

export default ParmViewer;
