/*global Module*/
"use strict";

/**
 * Class to keep genotypes data
 */
class Genotypes {

    /**
     * Default constructor for genotypes object
     * @param {string} path path to .gen file with genotypes
     */
    constructor(obj, path) {
        this.parent = obj;
        this.loaded = false;
        this.id = [];
        this.name = [];
        this.genotype = [];
        this.readGenotypesFromFile(path);
        
    }

    /**
     * Read genotypes from genotypes.gen file.
     * @param {string} file path to genotypes.gen
     */
    readGenotypesFromFile(file) {
        let rawFile = new XMLHttpRequest();
        rawFile.open("GET", file, true);
        rawFile.onload = (e) => {
            if (rawFile.readyState === 4) {
                if (rawFile.status === 200 || rawFile.status === 0) {
                      this.readGenotypesFromGenotypeLoader(rawFile.responseText);
                } else {
                    console.error(rawFile.statusText);
                }
            }
        };
        rawFile.onerror = (e) => {
            console.error(rawFile.statusText);
        };
        rawFile.send(null);
    }

    /**
     * Read genotypes from text read from genotypes.gen.
     * @param {string} text 
     */
    readGenotypesFromGenotypeLoader(text) {
        let textStringFile = new Module.StringFILE2(text, 0);
        let genotypeLoader = new Module.GenotypeMiniLoader(textStringFile);
        let loaded = genotypeLoader.loadNextGenotype();
        let i = 0;
        while (loaded.genotype.c_str()!="")
        {
            this.name.push(loaded.name.c_str());
            this.genotype.push(loaded.genotype.c_str());
            this.id.push(i);
            i++;

            loaded = genotypeLoader.loadNextGenotype();
        }
        this.loaded = true;
        this.parent.start();
    }
}


export default Genotypes;