package com.framsticks.model;

import java.io.InputStream;

import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

import com.framsticks.params.FramsClass;
import com.framsticks.params.ReflectionAccess;
import com.framsticks.params.SourceInterface;
import com.framsticks.parsers.FileSource;
import com.framsticks.parsers.Loaders;
import com.framsticks.test.TestConfiguration;

import static org.fest.assertions.Assertions.*;

@Test
public class PackageTest extends TestConfiguration {

	@Test(dataProvider = "classesList")
	public void testFramsClass(Class<?> javaClass, String name, int paramCount) throws InstantiationException, IllegalAccessException {
		// log.info("testing " + name + " " + javaClass + " " + Package.class.getResource(filename));
		String filename = "/info/" + name + ".info";
		InputStream stream = Package.class.getResourceAsStream(filename);
		assertThat(stream).describedAs("stream " + filename).isNotNull();

		SourceInterface source = new FileSource(stream, filename);

		assertThat(source.isClosed()).isFalse();
		FramsClass framsClass = Loaders.loadFramsClass(source);
		assertThat(framsClass).isNotNull();

		assertThat(framsClass.getParamCount()).isEqualTo(paramCount);
		ReflectionAccess access = new ReflectionAccess(javaClass, framsClass);
		Object object = javaClass.newInstance();
		access.select(object);
	}

	@DataProvider
	public Object[][] classesList() {
		return new Object[][] {
			{ MechPart.class, "MechPart", 20 },
			{ Joint.class, "Joint", 16 },
			{ MechJoint.class, "MechJoint", 10 },
			{ Neuro.class, "Neuro", 21},
			{ NeuroDef.class, "NeuroDef", 9},
			{ Part.class, "Part", 18},
			// { Model.class, "Model" },
			{ Creature.class, "Creature", 64 },
			{ Genotype.class, "Genotype", 37 },
			{ World.class, "World", 10 }
		};
	}
}
