package com.framsticks.util.lang;

/**
 * @author Piotr Sniegowski
 */
public abstract class Strings {

	public static String valueOf(Object o) {
		if (o == null) {
			return null;
		}
		return o.toString();
	}

	public static boolean notEmpty(String str) {
		return str != null && !str.equals("");
	}

	public static String toStringNullProof(Object object) {
		if (object == null) {
			return "";
		}
		return object.toString();
	}

	public static String collapse(String s) {
		if (s == null) {
			return null;
		}
		s = s.trim();
		return (s.equals("")) ? null : s;
	}

	public static Pair<String, String> splitIntoPair(String string, char separator, String second) {
		int pos = string.indexOf(separator);
		if (pos == -1) {
			return new Pair<String, String>(string.substring(0,
					string.length() - 1), second);
		} else {
			return new Pair<String, String>(string.substring(0, pos),
					string.substring(pos + 1));
		}
	}

	public static String capitalize(String input) {
		return input.substring(0, 1).toUpperCase() + input.substring(1);
	}

	public static String uncapitalize(String input) {
		return input.substring(0, 1).toLowerCase() + input.substring(1);
	}
}
