package com.framsticks.util.lang;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.collections.functors.InstanceofPredicate;
import org.apache.commons.collections.functors.NotPredicate;
import org.apache.commons.collections.iterators.FilterIterator;

/**
 * @author Piotr Sniegowski
 */
public abstract class Containers {
	public static void resizeList(List<?> list, int size) {
		while (list.size() < size) {
			list.add(null);
		}
		while (list.size() > size) {
			list.remove(list.size() - 1);
		}
	}

	public static <T> Iterable<T> filterInstanceof(Iterator<? super T> i, Class<T> type) {
		return new IterableIterator<T>(new FilterIterator(i, new InstanceofPredicate(type)));
	}

	public static <T> Iterable<T> filterInstanceof(Iterable<? super T> i, Class<T> type) {
		return new IterableIterator<T>(new FilterIterator(i.iterator(), new InstanceofPredicate(type)));
	}

	public static <T> Iterable<T> filterInstanceof(Collection<? super T> c, Class<T> type) {
		return new IterableIterator<T>(new FilterIterator(c.iterator(), new InstanceofPredicate(type)));
	}

	public static <T> Iterable<T> filterNotInstanceof(Collection<T> c, Class<? extends T> type) {
		return new IterableIterator<T>(new FilterIterator(c.iterator(), new NotPredicate(new InstanceofPredicate(type))));
	}
}
