package com.framsticks.util;

import java.util.ArrayList;
import java.util.List;

import com.framsticks.util.lang.Delimeted;
import com.framsticks.util.lang.Pair;

@SuppressWarnings("serial")
public class FramsticksException extends RuntimeException {

	protected List<Pair<String, Object>> arguments;
	protected String message;

	public FramsticksException() {
		super("framsticks exception");
	}

	public FramsticksException msg(String message) {
		this.message = message;
		return this;
	}

	public FramsticksException cause(Throwable cause) {
		initCause(cause);
		return this;
	}

	public FramsticksException arg(String header, Object argument) {
		if (arguments == null) {
			arguments = new ArrayList<>();
		}
		arguments.add(new Pair<String, Object>(header, argument));
		return this;
	}

	public String getMessage() {
		StringBuilder b = new StringBuilder();
		if (message != null) {
			b.append(message);
		}
		if (arguments != null) {
			if (message != null) {
				b.append(" ");
			}
			Delimeted d = new Delimeted(", ", "");
			d.append(arguments.iterator());

			b.append("(").append(d.build()).append(")");
		}
		return b.toString();
	}

}
