package com.framsticks.portals;

import com.framsticks.observers.Observer;
import com.framsticks.params.annotations.FramsClassAnnotation;
import com.framsticks.params.annotations.ParamAnnotation;
import com.framsticks.util.PeriodicTask;
import org.apache.log4j.Logger;


/**
 * @author Piotr Sniegowski
 */
@FramsClassAnnotation
public class Portal extends Observer {

	private final static Logger log = Logger.getLogger(Portal.class.getName());

	@ParamAnnotation
	public Integer counter = 0;

	public Portal() {
	}

	@Override
	public void run() {
		super.run();
		new PeriodicTask<Portal>(this, 1000) {

			@Override
			public void run() {
				++counter;
				log.debug("counter is now: " + counter);
				again();
			}
		};
	}

	@Override
	protected PortalEndpoint createEndpoint() {
		return new PortalEndpoint();
	}

	@ParamAnnotation(id = "counter_squared", name = "Counter Squared")
	public Double getCounterSquared() {
		return (double)(counter * counter);
	}

}
