package com.framsticks.parsers;

import com.framsticks.params.*;
import com.framsticks.params.SinkInterface;

/**
 * @author Piotr Sniegowski
 */
public class Savers {
	public static void saveFramsClass(SinkInterface sink, FramsClass framsClass) {

		AccessInterface framsClassAccess = new ReflectionAccess(FramsClass.class);
		AccessInterface paramAccess = new ReflectionAccess(Param.class);
		framsClassAccess.select(framsClass);
		framsClassAccess.save(sink);
		for (Param p : framsClass.getParamEntries()) {
			paramAccess.select(p);
			paramAccess.save(sink);
		}
	}

}
