package com.framsticks.parsers;

import com.framsticks.params.*;
// import org.apache.log4j.Logger;

/**
 * @author Piotr Sniegowski
 */
public class Loaders {

	// private static final Logger log = Logger.getLogger(Loaders.class.getName());

	public static FramsClass loadFramsClass(SourceInterface source) throws ConstructionException {
		MultiParamLoader loader = new MultiParamLoader();
		loader.setNewSource(source);

		FramsClass result = new FramsClass();

		AccessInterface framsClassAccess = new ReflectionAccess(FramsClass.class, FramsClassBuilder.buildForClass(FramsClass.class));
		AccessInterface paramBuilderAccess = new ReflectionAccess(ParamBuilder.class, FramsClassBuilder.buildForClass(ParamBuilder.class));
		framsClassAccess.select(result);
		loader.addAccessInterface(framsClassAccess);
		loader.addAccessInterface(paramBuilderAccess);

		loader.addBreakCondition(MultiParamLoader.Status.AfterObject);

		try {
			MultiParamLoader.Status condition;
			while ((condition = loader.go()) != MultiParamLoader.Status.Finished) {
				if (condition == MultiParamLoader.Status.AfterObject) {

					Object object = loader.returnObject();
					if (object instanceof FramsClass) {
						continue;
					}
					if (object instanceof ParamBuilder) {
						result.append(((ParamBuilder) object).finish());
					}
				}
			}
			return result;
		} catch (Exception e) {
			throw new ConstructionException().msg("an error occurred while loading class description").arg("before", loader.getCurrentLine()).cause(e);
		}
	}
}
