package com.framsticks.parsers;

import com.framsticks.params.SourceInterface;
import com.framsticks.util.io.Encoding;

import java.io.*;


public class FileSource implements SourceInterface {

	private BufferedReader reader;
	private final String filename;

	public FileSource(InputStream stream, String filename) {
		this.filename = filename;
		this.reader = new BufferedReader(new InputStreamReader(stream, Encoding.getFramsticksCharset()));
	}

	public FileSource(String filename) throws IOException {
		this(new FileInputStream(filename), filename);
	}

	public FileSource(InputStream stream) {
		this(stream, "<stream>");
	}

	@Override
	public String readLine()
	{
		assert !isClosed();
		try
		{
			return reader.readLine();
		} catch (IOException ignored) {

		}
		return null;
	}

	@Override
	public String getFilename()
	{
		return filename;
	}

	@Override
	public String demangleInclude(String include)
	{
		if (!include.contains(java.io.File.separator)) {
			String currentFilePath = (new java.io.File(filename)).getParent();
			if (!String.valueOf(
					currentFilePath.charAt(currentFilePath.length() - 1))
					.equals(java.io.File.separator)) {
				currentFilePath = currentFilePath + java.io.File.separator;
			}
			include = currentFilePath + include;
		}
		return include;
	}

	@Override
	public SourceInterface openInclude(String include)
	{
		try
		{
			return new FileSource(include);
		}
		catch(IOException e)
		{

		}
		return null;
	}

	@Override
	public void close()
	{
		try {
			reader.close();
		} catch (IOException e) {

		}
		reader = null;
	}

	@Override
	public boolean isClosed() {
		return reader == null;
	}

}
