package com.framsticks.params;

/**
 * @author Piotr Sniegowski
 */
public class SimpleSource implements SourceInterface {

	String content;
	int cursor;

	public SimpleSource(String content) {
		this.content = content;
		cursor = 0;
	}

	@Override
	public String getFilename() {
		return "<String>";
	}

	@Override
	public String readLine() {
		assert !isClosed();
		if (cursor >= content.length()) {
			return null;
		}
		int nextEndLine = content.indexOf('\n', cursor);
		if (nextEndLine == -1) {
			nextEndLine = content.length();
		}
		String result = content.substring(cursor, nextEndLine);
		cursor = nextEndLine + 1;
		return result;
	}

	@Override
	public String demangleInclude(String include) {
		return null;
	}

	@Override
	public SourceInterface openInclude(String include) {
		return null;
	}

	@Override
	public void close() {
		content = null;
	}

	//TODO no magic numbers
	@Override
	public boolean isClosed() {
		return content != null;
	}

}
