package com.framsticks.params;


import com.framsticks.params.types.DecimalParam;
import com.framsticks.params.types.StringParam;

/**
 * Based on c++ struct ParamEntry located in cpp/gdk/param.h
 * Here  it is a root of Param hierarchy.
 *
 * @author Jarek Szymczak <name.surname@gmail.com>, Mateusz Jarus
 * (please replace name and surname with my personal data)
 *
 * @author Piotr Śniegowski
 */
public abstract class Param {

	/** The parameter id. */
	protected String id;

	/**
	 * The parameter internal id. It's set by a user to use user's own getId in
	 * code
	 */
	protected String internalId;

	/** The parameter name. */
	protected String name;

	/** The help (description) concerning parameter. */
	protected String help;

	/** The number of group, that parameter belongs to. */
	protected Integer group;

	/** The getFlags stored as a bit sum. */
	protected Integer flags;

	/** The variable determining whether the parameter is an extra parameter. */
	protected Integer extra;


	public Param() {

	}

	public String getId() {
		return id;
	}

	public String getInternalId() {
		return internalId;
	}

	public String getName() {
		return name;
	}

	public String getHelp() {
		return help;
	}

	public Integer getGroup() {
		return group;
	}

	public Integer getFlags() {
		return flags;
	}

	public abstract String getFramsTypeName();


	public String getEffectiveId() {
		return (internalId != null) ? internalId : id;
	}


	public Integer getExtra() {
		return extra;
	}

	public void setInternalId(String internalId) {
		this.internalId = internalId;
	}

	@Override
	public String toString() {
		return getId() + ":" + this.getClass().getSimpleName();
	}

	public boolean isNumeric() {
		return false;
	}

	public abstract Class<?> getStorageType();

	public boolean hasFlag(int flag) {
		return flags != null && (flags & flag) != 0;
	}

	public boolean isUserHidden() {
		return (flags & Flags.USERHIDDEN) != 0;
	}

	public static FramsClass getFramsClass() {
		return new FramsClass("prop", "prop", null)
			.append(Param.build().id("name").name("Name").type(StringParam.class).finish())
			.append(Param.build().id("id").name("Id").type(StringParam.class).finish())
			.append(Param.build().id("type").name("Type").type(StringParam.class).finish())
			.append(Param.build().id("help").name("Help").type(StringParam.class).finish())
			.append(Param.build().id("flags").name("Flags").type(DecimalParam.class).finish());
	}

	public static ParamBuilder build() {
		return new ParamBuilder();
	}

}
