package com.framsticks.params;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ListSource implements SourceInterface {

	private Iterator<String> iterator = null;
	//private final List<String> source;

	public ListSource(List<String> source) {
		//this.source = source;
		iterator = source.iterator();
	}

	@Override
	public String getFilename() {
		return "<net>";
	}

	@Override
	public String readLine() {
		// if (iterator == null) {
		//	return null;
		// }
		assert iterator != null;
		if (iterator.hasNext()) {
			return iterator.next();
		}
		return null;
	}

	@Override
	public String demangleInclude(String include) {
		return null;
	}

	@Override
	public SourceInterface openInclude(String include) {
		return null;
	}

	@Override
	public void close() {
		iterator = null;
	}

	public static ListSource createFrom(String... lines) {
		List<String> list = new ArrayList<String>();
		for (String l : lines) {
			list.add(l);
		}
		return new ListSource(list);
	}

	@Override
	public boolean isClosed() {
		return iterator == null;
	}
}
