package com.framsticks.params;

import com.framsticks.util.lang.Numbers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

/**
 * @author Piotr Sniegowski
 */
public class ArrayListAccess extends ListAccess {

	List<Object> list;

	public ArrayListAccess(AccessInterface elementAccess) {
		super(elementAccess);
	}

	@Override
	public ArrayListAccess cloneAccess() throws ConstructionException {
		return new ArrayListAccess(elementAccess.cloneAccess());
	}

	@Override
	public List<?> createAccessee() {
		return new ArrayList<Object>();
	}

	@Override
	public Param getParam(int i) {
		return Param.build().id(Integer.toString(i)).name(elementAccess.getId()).type("o " + elementAccess.getId()).finish();
	}

	@Override
	public Param getParam(String id) {
		Integer i = Numbers.parse(id, Integer.class);
		return (i == null ? null : getParam(i));
	}

	@Override
	public String getId() {
		return "l " + elementAccess.getId();
	}

	@Override
	public int getParamCount() {
		return list.size();
	}

	@Override
	public <T> T get(int i, Class<T> type) {
		if (i < list.size()) {
			return type.cast(list.get(i));
		}
		return null;
	}

	@Override
	public <T> T get(String id, Class<T> type) {
		return get(Integer.parseInt(id), type);
	}

	@Override
	public <T> T get(ValueParam param, Class<T> type) {
		return get(param.getId(), type);
	}

	@Override
	public <T> int set(int i, T value) {
		while (i >= list.size()) {
			list.add(null);
		}
		list.set(i, value);
		return 0;
	}

	@Override
	public <T> int set(String id, T value) {
		return set(Integer.parseInt(id), value);
	}

	@Override
	public <T> int set(ValueParam param, T value) {
		return set(param.getId(), value);
	}

	@Override
	public void clearValues() {
		list.clear();
	}

	/** covariant */
	@Override
	public List<Object> getSelected() {
		return list;
	}

	@SuppressWarnings("unchecked")
	@Override
	public ArrayListAccess select(Object object) {
		list = (List<Object>) object;
		return this;
	}

	@Override
	public String computeIdentifierFor(Object selected) {
		return Integer.toString(list.size());
	}

	@Override
	public Collection<Param> getParams() {
		List<Param> result = new LinkedList<Param>();
		if (list == null) {
			return result;
		}
		for (int i = 0; i < list.size(); ++i) {
			result.add(getParam(i));
		}
		return result;
	}


}
