package com.framsticks.params;

import java.util.Collection;


/**
 * The Interface AccessInterface. It's the most general class for storing data in
 * framsticks. In descriptions of methods names "property" and "parameter" are
 * synonyms.
 *
 * @author Jarek Szymczak <name.surname@gmail.com> (please replace name and
 *         surname with my personal data)
 */
public interface AccessInterface {

	Param getParam(int i);

	Param getParam(String id);

	String getId();

	Param getGroupMember(int gi, int n);

	int getParamCount();

	// void call(int i, Object args, Object ret);
	// TODO: as for now it's not necessary to implement this method

	<T> T get(int i, Class<T> type);

	<T> T get(String id, Class<T> type);

	<T> T get(ValueParam param, Class<T> type);

	<T> int set(int i, T value);

	<T> int set(String id, T value);

	<T> int set(ValueParam param, T value);

	void setDefault(boolean numericOnly);

	void setDefault(int i, boolean numericOnly);

	void setMin();

	void setMin(int i);

	void setMax();

	void setMax(int i);

	void copyFrom(AccessInterface src);

	void save(SinkInterface sink);

	void load(SourceInterface stream) throws Exception;

	/**
	 * Removes all the properties values.
	 */
	void clearValues();

	AccessInterface select(Object object);

	Object getSelected();

	AccessInterface cloneAccess() throws ConstructionException;

	Object createAccessee();

	Collection<Param> getParams();

	FramsClass getFramsClass();


}
