package com.framsticks.observers;

import com.framsticks.core.Entity;
import com.framsticks.core.Instance;
import com.framsticks.core.Program;
import com.framsticks.params.annotations.FramsClassAnnotation;
import com.framsticks.params.annotations.ParamAnnotation;
import com.framsticks.util.lang.Casting;
import org.apache.commons.configuration.Configuration;
import org.apache.log4j.Logger;

import java.util.*;

/**
 * @author Piotr Sniegowski
 */
@FramsClassAnnotation
public abstract class Observer extends Entity {

	private final static Logger log = Logger.getLogger(Observer.class.getName());

	public Observer() {
	}

	@ParamAnnotation
	protected final Map<String, Endpoint> endpoints = new HashMap<String, Endpoint>();

	protected Endpoint createEndpoint() {
		return new Endpoint();
	}

	@Override
	public void configure(Configuration config) {
		super.configure(config);
		for (String n : config.getStringArray("endpoints")) {
			if (getEndpoints().containsKey(n)) {
				log.fatal("observer already contains endpoint named: " + n);
				continue;
			}
			Configuration instanceConfig = config.subset("endpoints." + n).subset("entity");
			Instance i = Casting.tryCast(Instance.class, Program.configureEntity(instanceConfig));
			if (i == null) {
				log.error("failed to create instance: ");
				continue;
			}
			i.setName(n);
			i.configure(instanceConfig);
			addEndpointForInstance(i);
		}
	}

	public Endpoint addEndpointForInstance(Instance instance) {
		Endpoint endpoint = createEndpoint();
		endpoint.configurePublic(this, instance, instance.getName());
		getEndpoints().put(instance.getName(), endpoint);
		log.info("instance " + instance + " was added to " + this + " as " + instance.getName());
		return endpoint;
	};

	@Override
	protected void run() {
		super.run();
		for (Endpoint e : getEndpoints().values()) {
			e.start();
		}
	}


	public Map<String, Endpoint> getEndpoints() {
		return endpoints;
	}



}
