package com.framsticks.observers;

import com.framsticks.core.Instance;
import com.framsticks.core.InstanceListener;
import com.framsticks.core.Path;
import com.framsticks.params.annotations.FramsClassAnnotation;
import com.framsticks.params.annotations.ParamAnnotation;
import com.framsticks.core.ListChange;
import com.framsticks.util.dispatching.Dispatcher;
import org.apache.log4j.Logger;
import com.framsticks.util.dispatching.RunAt;

/**
 * @author Piotr Sniegowski
 */
@FramsClassAnnotation
public class Endpoint implements Dispatcher<Instance>, InstanceListener {
	private final static Logger log = Logger.getLogger(Endpoint.class.getName());

	@ParamAnnotation
	protected Instance instance;
	protected Observer observer;

	@ParamAnnotation
	protected String name;

	public Endpoint() {
	}

	public final void configurePublic(Observer observer, Instance instance, String name) {
		assert instance != null;
		this.name = name;
		this.observer = observer;
		this.instance = instance;
		instance.addListener(this);
	}

	public void start() {
		instance.start();
	}

	@Override
	public void onListChange(Path path, ListChange change) {
		log.info("change " + change + " in " + path);
	}

	@Override
	public void onRun(Exception e) {
	}

	@Override
	public void onStop(Exception e) {
	}

	@Override
	public void onFetch(Path path) {
		log.trace("fetched " + path);
	}

	@Override
	public String toString() {
		return instance.toString();
	}

	public final Instance getInstance() {
		return instance;
	}

	@Override
	public final boolean isActive() {
		return instance.isActive();
	}

	@Override
	public final void invokeLater(RunAt<? extends Instance> runnable) {
		instance.invokeLater(runnable);
	}

	public Observer getObserver() {
		return observer;
	}

	public final String getName() {
		return name;
	}


}
