package com.framsticks.model;


import com.framsticks.params.annotations.FramsClassAnnotation;
import com.framsticks.params.annotations.ParamAnnotation;
import com.framsticks.util.math.Point3d;

/**
 * The Class Part.
 */
@FramsClassAnnotation(id = "p")
public class Part extends BasePart {

	@ParamAnnotation
	public double rx, ry, rz;


	public Point3d getRotation() { return new Point3d(rx, ry, rz); }
	public void setRotation(Point3d r) { rx = r.x; ry = r.y; rz = r.z; }

	@ParamAnnotation(id = "dn")
	public double density;

	@ParamAnnotation(id = "ing")
	public double ingestion;

	@ParamAnnotation(id = "as")
	public double assimilation;

	@ParamAnnotation(id = "i")
	public String info;

	@ParamAnnotation(id = "Vstyle")
	public String visualizationStyle;

	@ParamAnnotation(id = "vs")
	public double visualThickness;

	@ParamAnnotation
	public double vr, vg, vb;

}
