package com.framsticks.model;

import com.framsticks.params.annotations.FramsClassAnnotation;
import com.framsticks.params.annotations.ParamAnnotation;
import com.framsticks.util.lang.Casting;
import com.framsticks.util.lang.Containers;
import com.framsticks.util.lang.IterableIterator;
import com.framsticks.util.math.Orientation;
import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * Author: Piotr Śniegowski
 */
@FramsClassAnnotation(id = "m")
public class Model {

	private final static Logger log = Logger.getLogger(Model.class);

	@ParamAnnotation(id = "se")
	public double startingEnergy;

	@ParamAnnotation
	public double getEnerg0() { return startingEnergy; }
	@ParamAnnotation
	public void setEnerg0(double energ0) { startingEnergy = energ0; }


	@ParamAnnotation(id = "Vstyle")
	public String visualizationStyle;

	@ParamAnnotation
	public final List<Part> parts = new ArrayList<Part>();

	@ParamAnnotation
	public final List<Joint> joints = new ArrayList<Joint>();

	@ParamAnnotation
	public final List<NeuroDef> neurodefs = new ArrayList<NeuroDef>();

	//TODO: why those methods returns and accepts doubles?
	@ParamAnnotation
	public double getNumparts() { return (double)parts.size(); }
	@ParamAnnotation
	public double getNumjoints() { return (double)joints.size(); }
	@ParamAnnotation
	public double getNumneurons() { return (double)neurodefs.size(); }

	//this is impossible to use, because numparts field is marked as readonly
	@ParamAnnotation
	public void setNumparts(double numparts) { Containers.resizeList(parts, (int) (double) numparts); }
	@ParamAnnotation
	public void setNumjoints(double numjoints) { Containers.resizeList(joints, (int)(double)numjoints); }
	@ParamAnnotation
	public void setNumneurons(double numneurons) { Containers.resizeList(neurodefs, (int)(double)numneurons); }

	public List<Part> getParts() { return parts; }
	public List<Joint> getJoints() { return joints; }
	public List<NeuroDef> getNeuroDefs() { return neurodefs; }

	public static Model build(List<Object> objects) {
		Iterator<Object> i = objects.iterator();
		if (!i.hasNext()) {
			return null;
		}
		Model f0Genotype = Casting.tryCast(Model.class, i.next());
		if (f0Genotype == null) {
			log.fatal("first object is not a Model");
			return null;
		}
		for (Object object : new IterableIterator<Object>(i)) {
			if (object instanceof Joint) {
				f0Genotype.joints.add((Joint)object);
				continue;
			}
			if (object instanceof Part) {
				f0Genotype.parts.add((Part)object);
				continue;
			}
			if (object instanceof NeuroDef) {
				f0Genotype.neurodefs.add((NeuroDef) object);
				continue;
			}
			log.error("invalid class: " + object.getClass().getCanonicalName());
		}

		for (Part p : f0Genotype.getParts()) {
			p.setOrientation(new Orientation().rotate(p.getRotation()));
		}
		for (Joint j : f0Genotype.getJoints()) {
			/** based on c++ Joint::attachToParts*/
			Part p1 = f0Genotype.parts.get(j.part1);
			Part p2 = f0Genotype.parts.get(j.part2);
			assert p1 != null && p2 != null;
			Orientation o = new Orientation().rotate(j.getRotation());
			p2.setOrientation(p1.getOrientation().transform(o));
			p2.setPosition(p2.getOrientation().transform(j.getDelta()).add(p1.getPosition()));
		}
		return f0Genotype;
	}
}
