package com.framsticks.model;

import com.framsticks.params.annotations.FramsClassAnnotation;
import com.framsticks.params.annotations.ParamAnnotation;
import com.framsticks.util.math.Point3d;

import java.util.ArrayList;
import java.util.List;

@FramsClassAnnotation
public class Creature {

	@ParamAnnotation
	public String name;

	@ParamAnnotation
	public String genotype;

	@ParamAnnotation
	public String info;

	@ParamAnnotation
	public Object group;

	@ParamAnnotation(id = "gnum")
	public int generation;

	@ParamAnnotation(id = "buildproblems")
	public int buildProblems;

	@ParamAnnotation(id = "energ0")
	public double startingEnergy;

	@ParamAnnotation(id = "idleen")
	public double idlePowerConsumption;

	@ParamAnnotation
	public double energy;

	@ParamAnnotation(id = "energy_p")
	public double energyIncome;

	@ParamAnnotation(id = "energy_m")
	public double energyCosts;

	@ParamAnnotation(id = "energy_b")
	public double energyBalance;

	@ParamAnnotation(id = "perf")
	public int performanceCalculation;

	@ParamAnnotation(id = "nnenabled")
	public boolean neuralNetworkEnabled;

	@ParamAnnotation(id = "bodysim")
	public boolean bodySimulation;

	@ParamAnnotation(id = "selfcol")
	public boolean selfCollisions;

	@ParamAnnotation(id = "lifespan")
	public int lifeSpan;

	@ParamAnnotation
	public double distance;

	@ParamAnnotation(id = "c_velocity")
	public double currentVelocity;

	@ParamAnnotation(id = "c_vertvelocity")
	public double currentVerticalVelocity;

	@ParamAnnotation(id = "c_vertpos")
	public double currentVerticalPosition;

	@ParamAnnotation(id = "velocity")
	public double averageVelocity;

	@ParamAnnotation(id = "vertvel")
	public double averageVerticalVelocity;

	@ParamAnnotation(id = "vertpos")
	public double averageVerticalPosition;

	@ParamAnnotation
	public double pos_x, pos_y, pos_z;

	public Point3d getPosition() { return new Point3d(pos_x, pos_y, pos_z) ; }
	public void setPosition(Point3d pos) { pos_x = pos.x; pos_y = pos.y; pos_z = pos.z; }

	@ParamAnnotation
	public double size_x, size_y, size_z;

	public Point3d getBoundingBox() { return new Point3d(size_x, size_y, size_z) ; }
	public void setBoundingBox(Point3d size) { size_x = size.x; size_y = size.y; size_z = size.z; }


	/** center_x, center_y, center_z*/
	@ParamAnnotation
	public double center_x, center_y, center_z;

	public Point3d getCenter() { return new Point3d(center_x, center_y, center_z) ; }
	public void setCenter(Point3d center) { center_x = center.x; center_y = center.y; center_z = center.z; }

	@ParamAnnotation
	public int getNumparts() { return parts.size(); }
	@ParamAnnotation
	public void setNumparts(int numparts) { }

	@ParamAnnotation
	public int getNumjoints() { return joints.size(); }
	@ParamAnnotation
	public void setNumjoints(int numjoints) { }

	@ParamAnnotation
	public int getNumneurons() { return neurons.size(); }
	@ParamAnnotation
	public void setNumneurons(int numneurons) { }

	public Object[] userFields = new Object[3];
	@ParamAnnotation
	public Object getUser1() { return userFields[0]; }
	@ParamAnnotation
	public void setUser1(Object user1) { userFields[0] = user1; }

	@ParamAnnotation
	public Object getUser2() { return userFields[1]; }
	@ParamAnnotation
	public void setUser2(Object user2) { userFields[1] = user2; }

	@ParamAnnotation
	public Object getUser3() { return userFields[2]; }
	@ParamAnnotation
	public void setUser3(Object user3) { userFields[2] = user3; }

	@ParamAnnotation(id = "selfmask")
	public int selfCollisionMask;

	@ParamAnnotation(id = "othermask")
	public int otherCollisionMask;

	@ParamAnnotation(id = "selfcolstate")
	public boolean selfCollisionsState;

	@ParamAnnotation
	public String uid;

	@ParamAnnotation
	public int index;

	@ParamAnnotation
	public final List<Part> parts = new ArrayList<Part>();
	@ParamAnnotation
	public final List<Joint> joints = new ArrayList<Joint>();
	@ParamAnnotation
	public final List<NeuroDef> neurodefs = new ArrayList<NeuroDef>();

	public final List<Part> getParts() { return parts; }
	public final List<Joint> getJoints() { return joints; }
	public final List<NeuroDef> getNeuroDefs() { return neurodefs; }

	@ParamAnnotation
	public final List<MechPart> mechparts = new ArrayList<MechPart>();
	@ParamAnnotation
	public final List<MechJoint> mechjoints = new ArrayList<MechJoint>();
	@ParamAnnotation
	public final List<Neuro> neurons = new ArrayList<Neuro>();

	public final List<MechPart> getMechParts() { return mechparts; }
	public final List<MechJoint> getMechJoints() { return mechjoints; }
	public final List<Neuro> getNeurons() { return neurons; }

}
