package com.framsticks.model;

import com.framsticks.params.annotations.ParamAnnotation;
import com.framsticks.util.math.Orientation;
import com.framsticks.util.math.Point3d;

/**
 * Author: Piotr Śniegowski
 */
public class BasePart {

	@ParamAnnotation
	public double x, y, z;

	public Point3d getPosition() { return new Point3d(x, y, z); }
	public void setPosition(Point3d p) { x = p.x; y = p.y; z = p.z; }

	@ParamAnnotation(id = "m")
	public double mass = 0.0;

	@ParamAnnotation(id = "s")
	public double size = 0.0;

	@ParamAnnotation(id = "fr")
	public double friction;

	@ParamAnnotation
	public double oxx, oxy, oxz, oyx, oyy, oyz, ozx, ozy, ozz;

	public Orientation getOrientation() { return new Orientation(new Point3d(oxx, oxy, oxz), new Point3d(oyx, oyy, oyz), new Point3d(ozx, ozy, ozz)); }

	public void setOrientation(Orientation o) {
		oxx = o.x.x;
		oxy = o.x.y;
		oxz = o.x.z;
		oyx = o.y.x;
		oyy = o.y.y;
		oyz = o.y.z;
		ozx = o.z.x;
		ozy = o.z.y;
		ozz = o.z.z;
	}

	public void copyFrom(BasePart p) {
		setPosition(p.getPosition());
		setOrientation(p.getOrientation());
		mass = p.mass;
		size = p.size;
		friction = p.friction;
	}
}
