package com.framsticks.model;

import com.framsticks.params.annotations.ParamAnnotation;
import com.framsticks.util.math.Point3d;

/**
 * Author: Piotr Śniegowski
 */
public class BaseJoint {

	@ParamAnnotation(id = "stif")
	public double stiffness;

	@ParamAnnotation(id = "rotstif")
	public double rotationStiffness;

	@ParamAnnotation
	public double rx, ry, rz;

	public Point3d getRotation() { return new Point3d(rx, ry, rz); }
	public void setRotation(Point3d r) { rx = r.x; ry = r.y; rz = r.z; }

	@ParamAnnotation
	public double dx, dy, dz;

	public Point3d getDelta() { return new Point3d(dx, dy, dz); }
	public void setDelta(Point3d d) { dx = d.x; dy = d.y; dz = d.z; }

	public void copyFrom(BaseJoint j) {
		stiffness = j.stiffness;
		rotationStiffness = j.rotationStiffness;
		setRotation(j.getRotation());
		setDelta(j.getDelta());
	}
}
