package com.framsticks.hosting;

import com.framsticks.core.*;
import com.framsticks.params.CompositeParam;
import com.framsticks.params.ConstructionException;
import com.framsticks.params.FramsClass;
import com.framsticks.params.FramsClassBuilder;
import com.framsticks.params.Param;
import com.framsticks.core.LocalInstance;
import com.framsticks.util.dispatching.Future;

import org.apache.commons.configuration.Configuration;
import org.apache.log4j.Logger;

/**
 * @author Piotr Sniegowski
 */
public class ServerInstance extends LocalInstance {

	private final static Logger log = Logger.getLogger(ServerInstance.class.getName());

	Entity hosted;

	public ServerInstance() {
	}

	@Override
	protected void run() {
		super.run();
		assert hosted != null;
		hosted.start();
	}

	@Override
	public void configure(Configuration config) {
		super.configure(config);

		Configuration hostedConfig = config.subset("hosted.entity");
		hosted = Program.configureEntity(hostedConfig);
		if (hosted == null) {
			log.fatal("failed to create hosted entity");
			return;
		}
		hosted.setName("hosted");
		hosted.configure(hostedConfig);
		root = new Node((CompositeParam) Param.build().name("root").id("root").type("o" + hosted.getClass().getCanonicalName()).finish(), hosted);
	}

	@Override
	public FramsClass getInfoFromCache(String id) {
		assert isActive();
		if (id == null) {
			return null;
		}
		FramsClass cached = registry.getInfoFromCache(id);
		if (cached != null) {
			return cached;
		}
		try {
			Class<?> nativeClass = Class.forName(id);
			FramsClass framsClass = FramsClassBuilder.buildForClass(nativeClass);

			if (!framsClass.getId().equals(id)) {
				log.error("no matching id");
				return null;
			}

			registry.registerReflectedClass(null, id, nativeClass);
			registry.putInfoIntoCache(framsClass);
			return framsClass;
		} catch (ClassNotFoundException ignored) {
		} catch (ConstructionException e) {
			log.error("failed to use info from cache: " + e);
		}

		return null;
	}

	@Override
	protected void fetchInfo(Path path, Future<FramsClass> future) {
		assert isActive();

		FramsClass framsClass = getInfoFromCache(path.getTop().getObject().getClass().getCanonicalName());
		if (framsClass == null) {
			log.error("failed to create frams class for: " + path.getTop().getObject().getClass());
			future.result(null, new Exception());
			return;
		}
		future.result(framsClass, null);

	}

	@Override
	protected void tryRegisterOnChangeEvents(Path path) {
	}

}
