package com.framsticks.gui.controls;

import java.awt.BorderLayout;

import javax.swing.JComponent;
import javax.swing.JPanel;

import com.framsticks.gui.Frame;
import com.framsticks.params.Flags;
import com.framsticks.params.Param;

/**
 * Interface that each class that want to be component must implement.
 */
@SuppressWarnings("serial")
public abstract class Control extends JPanel {

	public static final int LINE_HEIGHT = 36;

	// private static final Logger log = Logger.getLogger(Control.class.getName());

	protected Frame frame;
	protected final Param param;

	public Control(Param param) {
		this.param = param;

		this.setEnabled(!param.hasFlag(Flags.READONLY));
		// TODO: take care of textField exception: setEditable
	}

	public Param getParam() {
		return param;
	}

	public void setFrame(Frame frame) {
		this.frame = frame;
	}

	protected void addAsOnlyChild(JComponent component) {
		this.setLayout(new BorderLayout());
		this.add(component, BorderLayout.CENTER);
	}

	@Override
	public String toString() {
		return param.toString();
	}
}
