package com.framsticks.gui;

import javax.swing.JFrame;

import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.log4j.Logger;
import org.fest.swing.edt.FailOnThreadViolationRepaintManager;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.edt.GuiTask;
import org.fest.swing.fixture.FrameFixture;
import org.fest.swing.fixture.JTreeFixture;
// import static org.fest.swing.edt.GuiActionRunner.*;
import org.testng.annotations.*;

import com.framsticks.communication.ClientConnection;
import com.framsticks.remote.RemoteInstance;
import com.framsticks.test.TestConfiguration;

import static org.fest.assertions.Assertions.*;
import static org.fest.swing.core.BasicRobot.robotWithNewAwtHierarchy;
import static org.fest.swing.edt.GuiActionRunner.*;
import org.fest.swing.core.Robot;

public class BrowserTest extends TestConfiguration {
	private static final Logger log = Logger.getLogger(BrowserTest.class);

	Browser browser;
	Robot robot;
	FrameFixture frame;

	@BeforeClass
	public void setUp() {
		FailOnThreadViolationRepaintManager.install();
		assertThat(executeInEDT()).isTrue();

		robot = robotWithNewAwtHierarchy();

		browser = new Browser();
		browser.configure(new PropertiesConfiguration());

		RemoteInstance localhost = new RemoteInstance();
		localhost.setName("localhost");
		localhost.setConnection(new ClientConnection("localhost:9009"));

		browser.addEndpointForInstance(localhost);

		browser.start();
		// robot.waitForIdle();
		frame = new FrameFixture(robot,
				GuiActionRunner.execute(new GuiQuery<JFrame>() {
					@Override
					protected JFrame executeInEDT() throws Throwable {
						return browser.getMainFrame();
					}
				}));

		log.info("frame fixture done");
		// frame.show();
		// log.info("frame fixture shown");
	}

	public void clickAndExpandPath(JTreeFixture tree, String path) {
		tree.clickPath(path).expandPath(path);
		robot.waitForIdle();
	}

	@Test
	public void testShow() {
		log.info("testing");
		JTreeFixture tree = frame.tree("tree");
		tree.clickRow(0).expandRow(0);
		robot.waitForIdle();
		tree.clickRow(1).expandRow(1);
		robot.waitForIdle();
		assertThat(tree.valueAt(1)).isEqualTo("simulator");
		robot.waitForIdle();
		execute(new GuiTask() {
			@Override
			protected void executeInEDT() throws Throwable {
				assertThat(frame.panel("o Simulator").component().isVisible())
						.isTrue();
			}
		});

		clickAndExpandPath(tree, "localhost/simulator/genepools");
		clickAndExpandPath(tree, "localhost/simulator/genepools/groups");
		clickAndExpandPath(tree, "localhost/simulator/genepools/groups/Genotypes");
		// tree.clickPath("localhost/simulator/genepools/groups/Genotypes/genotypes");
		// robot.waitForIdle();
		// sleep(2);
		// tree.expandPath("localhost/simulator/genepools/groups/Genotypes/genotypes");

		// tree.expandRow(tree.component().getLeadSelectionRow() + 1);
		// robot.waitForIdle();

		// sleep(2);
	}

	public void sleep(int seconds) {
		try {
			Thread.sleep(seconds * 1000, 0);
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
	}

	@AfterClass
	public void tearDown() {
		// frame.close();
		frame.cleanUp();
	}

}
