import platform, sys


def init_colors(args):
	global ANSI_SETGREEN, ANSI_SETRED, ANSI_RESET
	if args.nocolor:
		ANSI_SETGREEN = ANSI_SETRED = ANSI_RESET = ''
	else:
		ANSI_SETGREEN = '\x1b[32m' + '\x1b[1m'  # after '+' there is brightness control (making brighter)
		ANSI_SETRED = '\x1b[31m' + '\x1b[1m'
		ANSI_RESET = '\x1b[39m' + '\x1b[0m'  # after '+' the brightness is reset
		if platform.system() == "Windows":
			try:
				from colorama import init, Fore, Style  # Fore and Style are here just to get ansi codes to control color and brightness
			except ImportError:
				print("The colorama module not available - there will be no ansi stdout colors")
				ANSI_SETGREEN = ANSI_SETRED = ANSI_RESET = ''
			else:
				init()  # from colorama
				# print repr(Fore.GREEN) # print sample ansi codes (just for debugging/curiosity)
				# print repr(Fore.RED)
				# print repr(Fore.RESET)
				# print repr(Style.BRIGHT)


def stripEOL(s):
	for char in '\n\r':
		if s[-1:len(s)] == char:
			s = s[:-1]
	return s


################################################################ main ################################################################

# no longer assuming any specific directory layout, use -tp/-wp/-fp to configure as needed
THISDIR = "."  # -tp
EXEDIR = "."  # -wp
FILESDIR = "."  # -fp

# special ways of comparison, to be used in 'out' lines
SPEC_REGEXP = "*REGEXP*:"
SPEC_SKIPTO = "*SKIPTO*:"  # skips any number of lines until a matching line is found
SPEC_INSERTPLATFORMDEPENDENTFILE = "*INSERTPLATFORMDEPENDENTFILE*:"  # loads into this location a file from disk, appending the platform name to the file name. Convention: we either use a single non-specialized file (i.e. results are identical everywhere) or we don't prepare such a single file, but we prepare all specialized files with separate results for each platform

WIN_SLASH_SENSITIVE = False

EXENETMODE = ["-N"]
ini = ""
EXEVALGRINDMODE = ["bash", "vg", "--leak-check=full"]

# data becomes a home dir so that tester can find what it looks for.
# As a resource dir we set 'emptydata' to make frams use only home, but still use splitfilesys.
# You could also set -Ddata to activate the mode with no splitfilesys.
EXENAMES = {"default": ["frams.exe", "-ddata", "-Demptydata", "-Q", "-s"],
			"theater": ["theater.exe", "-ddata", "-Demptydata", "-Q", "st"]}

EXERULES = []

PLATFORM = sys.platform
