package com.framsticks.portals;

import com.framsticks.core.Parameters;
import com.framsticks.observers.Observer;
import com.framsticks.params.FramsClass;
import com.framsticks.util.PeriodicTask;
import org.apache.log4j.Logger;


/**
 * @author Piotr Sniegowski
 */
public class Portal extends Observer {

    private final static Logger LOGGER = Logger.getLogger(Portal.class.getName());

    public Integer counter = 0;

    public Portal(Parameters parameters) {
        super(parameters);
    }

    @Override
    public void run() {
        super.run();
        new PeriodicTask(this, 1000) {

            @Override
            public void run() {
                ++counter;
                LOGGER.debug("counter is now: " + counter);
                again();
            }
        };
    }

    @Override
    protected void configure() throws Exception {
        super.configure();
    }


    @Override
    protected PortalEndpoint createEndpoint() {
        return new PortalEndpoint();
    }

    public Double getCounterSquared() {
        return (double)(counter * counter);
    }

    public static void constructFramsClass(FramsClass.Constructor constructor) {
        constructor.method("getCounterSquared").field("counter");
    }
}
