package com.framsticks.parsers;

import com.framsticks.params.SourceInterface;

import java.io.*;


public class FileSource implements SourceInterface {

	private BufferedReader reader;
	private String filename;
	
	public FileSource(String filename) throws IOException
	{
		this.filename = filename;
        reader = new BufferedReader(new FileReader(filename));
	}

	public FileSource(InputStream stream) {
		filename = "<stream>";
		reader = new BufferedReader(new InputStreamReader(stream));
	}


    @Override
    public String readLine()
	{
		try
		{
			return reader.readLine();
		} catch (IOException ignored) {

		}
		return null;
	}

    @Override
    public String getFilename()
	{
		return filename;
	}

    @Override
    public String demangleInclude(String include)
	{
		if (!include.contains(java.io.File.separator)) {
			String currentFilePath = (new java.io.File(filename)).getParent();
			if (!String.valueOf(
					currentFilePath.charAt(currentFilePath.length() - 1))
					.equals(java.io.File.separator)) {
				currentFilePath = currentFilePath + java.io.File.separator;
			}
			include = currentFilePath + include;
		}	
		return include;
	}

    @Override
    public SourceInterface openInclude(String include)
	{
		try
		{
			return new FileSource(include);
		}
		catch(IOException e)
		{
			
		}
		return null;
	}

    @Override
    public void close()
	{
		try {
			reader.close();
		} catch (IOException e) {
			
		}
	}
	
}
