package com.framsticks.params;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Piotr Sniegowski
 */
public abstract class Util {
    public static String readSourceToString(SourceInterface source) {
        StringBuilder result = new StringBuilder();
        String line;
        while ((line = source.readLine()) != null) {
            result.append(line).append(" ");
        }
        source.close();
        return result.toString();
    }
	public static List<Object> stripAccessInterface(List<AccessInterface> accesses) {
		List<Object> result = new ArrayList<Object>();
		for (AccessInterface a : accesses) {
			result.add(a.getSelected());
		}
		return result;
	}
	public static int copyParams(AccessInterface to, AccessInterface from) {
		int copied = 0;
		for (Param f : from.getParams()) {
			Param t = from.getParam(f.getId());
			if (t == null) {
				continue;
			}
			if (to.getClass() != f.getClass()) {
				continue;
			}
			to.set(t, from.get(f, Object.class));
			++copied;
		}
		return copied;
	}
}
