package com.framsticks.params;

import org.apache.log4j.Logger;

import java.util.HashMap;
import java.util.Map;

/**
 * Author: Piotr Śniegowski
 */
public class Registry {
	private static final Logger LOGGER = Logger.getLogger(Registry.class.getName());

	protected final Map<String, Class> reflectedClasses = new HashMap<String, Class>();
	protected final Map<String, String> invertedReflectedClasses = new HashMap<String, String>();
	protected final Map<String, FramsClass> infoCache = new HashMap<String, FramsClass>();

	public final void registerReflectedClass(String name, String id, String className) {
		try {
			registerReflectedClass(name, id, Class.forName(className));
		} catch (ClassNotFoundException e) {
			LOGGER.fatal("class not found during registration: " + e);
		}
	}

	public void registerReflectedClass(String name, String id, Class reflectedClass) {
		if (name != null) {
			reflectedClasses.put(name, reflectedClass);
			invertedReflectedClasses.put(reflectedClass.getCanonicalName(), name);
		}
		if (id != null) {
			reflectedClasses.put(id, reflectedClass);
		}
	}

	public AccessInterface createAccess(String name, FramsClass framsClass) {
		if (reflectedClasses.containsKey(name)) {
			return new ReflectionAccess(reflectedClasses.get(name), framsClass);
		}
		return new PropertiesAccess(framsClass);
	}

	public void putInfoIntoCache(FramsClass framsClass) {
		if (infoCache.containsKey(framsClass.getId())) {
			LOGGER.info("already cached " + framsClass);
			return;
		}
		LOGGER.debug("caching info for " + framsClass);
		infoCache.put(framsClass.getId(), framsClass);
		infoCache.put(framsClass.getName(), framsClass);
	}

	public FramsClass getInfoFromCache(String id) {
		if (id == null) {
			return null;
		}
		if (infoCache.containsKey(id)) {
			return infoCache.get(id);
		}
		if (invertedReflectedClasses.containsKey(id)) {
			return getInfoFromCache(invertedReflectedClasses.get(id));
		}
		return null;
	}
}
