package com.framsticks.params;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * The Class PropertiesAccess.
 * 
 * @author Jarek Szymczak <name.surname@gmail.com> (please replace name and
 *         surname with my personal data)
 *
 * @author Piotr Śniegowski
 */
public class PropertiesAccess extends SimpleAbstractAccess {

	public Map<String, Object> properties;

    @Override
	public Map<String, Object> createAccessee() {
		return PropertiesAccess.createPropertiesMap();
	}

	public static Map<String, Object> createPropertiesMap() {
		return new HashMap<String, Object>();
	}

	public PropertiesAccess(FramsClass framsClass) {
		setFramsClass(framsClass);
	}

	@Override
	public void clearValues() {
        assert properties != null;
        properties.clear();
	}

	@Override
	public <T> T get(Param param, Class<T> type) {
        assert properties != null;
        assert param != null;
		Object object = null;
		try {
			object = properties.get(param.getId());
			if (object == null) {
				return param.getDef(type);
			}
			return type.cast(object);
		} catch (ClassCastException e) {
			throw new ClassCastException("property " + param.getId() + " type is " + object.getClass().getName() + ", not " + type.getName());
		}

	}

	protected <T> void internalSet(Param param, T value) {
		properties.put(param.getId(), value);
	}

	/**
	 * Sets the new values to operate on. It does not check whether the values
	 * which are set through this method are correct. If set values are not
	 * correct exceptions might occurred while getting / setting the parameters
	 * values
	 * 
	 * @param object
	 *            the properties with parameters values
	 */
	@Override
	public void select(Object object) {
		this.properties = (Map<String, Object>)object;
	}

	/** covariant */
	@Override
	public Map<String, Object> getSelected() {
		return properties;
	}

	@Override
	public PropertiesAccess cloneAccess() {
		return new PropertiesAccess(framsClass);
		//properties = createProperties();
		//return access;
	}


}
