package com.framsticks.params;

import com.framsticks.core.Node;
import com.framsticks.core.Path;
import com.framsticks.params.types.CompositeParam;

import java.util.List;

/**
 * @author Piotr Sniegowski
 */
public abstract class ListAccess implements AccessInterface {

	final AccessInterface elementAccess;

	public ListAccess(AccessInterface elementAccess) {
		this.elementAccess = elementAccess;
	}

    @Override
	public Param getGroupMember(int gi, int n) {
		return null;
	}

	@Override
	public void setDefault(boolean numericOnly) {
	}

	@Override
	public void setDefault(int i, boolean numericOnly) {
	}

	@Override
	public void setMin() {
	}

	@Override
	public void setMin(int i) {
	}

	@Override
	public void setMax() {
	}

	@Override
	public void setMax(int i) {
	}

	@Override
	public void copyFrom(AccessInterface src) {
	}

	@Override
    public void save(SinkInterface sink) {
        for (Param p : getParams()) {
            assert p instanceof CompositeParam;
            CompositeParam childParam = (CompositeParam)p;
            Object child = get(childParam, Object.class);
            //this is probably an assertion
            assert child != null;
            elementAccess.select(child);
            elementAccess.save(sink);
        }
    }

	@Override
	public void load(SourceInterface stream) throws Exception {
	}

	@Override
	public String save2(boolean omitDefaultValues) {
		return null;
	}

	public AccessInterface getElementAccess() {
		return elementAccess;
	}

    public abstract String computeIdentifierFor(Object selected);

    @Override
    public final FramsClass getFramsClass() {
        return elementAccess.getFramsClass();
    }

}
