package com.framsticks.params;

import java.util.Collection;
import java.util.List;


/**
 * The Interface AccessInterface. It's the most general class for storing data in
 * framsticks. In descriptions of methods names "property" and "parameter" are
 * synonyms.
 * 
 * @author Jarek Szymczak <name.surname@gmail.com> (please replace name and
 *         surname with my personal data)
 */
public interface AccessInterface {

	Param getParam(int i);

	Param getParam(String id);

	String getId();


    /*
    	String getName();

    * This method provides more verbose (but not strict) names of classes.
     *
     * e.g. for a list it will return l Type, and if name of FramsClass missing,
     * it's id will be used
     *
    String getNiceName();
    */

	Param getGroupMember(int gi, int n);

	int getParamCount();

	// void call(int i, Object args, Object ret);
	// TODO: as for now it's not necessary to implement this method

	<T> T get(int i, Class<T> type);

	<T> T get(String id, Class<T> type);

	<T> T get(Param param, Class<T> type);

	<T> int set(int i, T value);

	<T> int set(String id, T value);

	<T> int set(Param param, T value);

	void setDefault(boolean numericOnly);

	void setDefault(int i, boolean numericOnly);

	void setMin();

	void setMin(int i);

	void setMax();

	void setMax(int i);

	void copyFrom(AccessInterface src);

	void save(SinkInterface sink);

	void load(SourceInterface stream) throws Exception;

	/**
	 * Return as a single line String.
	 * 
	 * @param omitDefaultValues
	 *            the omit default values
	 * @return the string
	 */
	String save2(boolean omitDefaultValues);

	/**
	 * Removes all the properties values.
	 */
	void clearValues();

	void select(Object object);

	Object getSelected();

	AccessInterface cloneAccess();

    Object createAccessee();

    Collection<Param> getParams();

    FramsClass getFramsClass();


}