package com.framsticks.observers;

import com.framsticks.core.Entity;
import com.framsticks.core.Instance;
import com.framsticks.core.Parameters;
import com.framsticks.core.Program;
import com.framsticks.params.FramsClass;
import com.framsticks.util.Casting;
import org.apache.commons.configuration.Configuration;
import org.apache.log4j.Logger;

import java.util.*;

/**
 * @author Piotr Sniegowski
 */
public abstract class Observer extends Entity {

    private final static Logger LOGGER = Logger.getLogger(Observer.class.getName());

    public Observer(Parameters parameters) {
        super(parameters);
    }

    protected final Map<String, Endpoint> endpoints = new HashMap<String, Endpoint>();

    protected Endpoint createEndpoint() {
        return new Endpoint();
    }

    @Override
    protected void configure() throws Exception {
        super.configure();
        for (String name : config.getStringArray("endpoints")) {
            if (getEndpoints().containsKey(name)) {
                LOGGER.fatal("observer already contains endpoint named: " + name);
                continue;
            }
            Configuration c = config.subset("endpoints." + name);
            Parameters p = new Parameters(c.subset("entity"), name, null, null);
            Entity e = Program.configureEntity(p);
            Instance i = Casting.tryCast(Instance.class, e);
            if (i == null) {
                LOGGER.error("failed to create instance: " + p);
                continue;
            }
            i.configurePublic();
            Endpoint endpoint = createEndpoint();
            endpoint.configurePublic(this, i, name);
            getEndpoints().put(name, endpoint);
            LOGGER.info("instance " + i + " was added to " + Observer.this);
        }
    }

    @Override
    protected void run() {
        super.run();
        for (Endpoint e : getEndpoints().values()) {
            e.getInstance().start();
        }
    }


    public Map<String, Endpoint> getEndpoints() {
        return endpoints;
    }

    public static void constructFramsClass(FramsClass.Constructor constructor) {
        constructor.method("getEndpoints");
    }


}
