package com.framsticks.model;

import com.framsticks.params.FramsClass;
import com.framsticks.params.Registry;
import com.framsticks.util.Orientation;
import com.framsticks.util.Point3d;

/**
 * Author: Piotr Śniegowski
 */
public class Package {
	public static void register(Registry registry) {
		registry.registerReflectedClass("MechPart", null, "com.framsticks.model.MechPart");
		registry.registerReflectedClass("Joint", "j", "com.framsticks.model.Joint");
		registry.registerReflectedClass("MechJoint", null, "com.framsticks.model.MechJoint");
		registry.registerReflectedClass("Neuro", null, "com.framsticks.model.Neuro");
		registry.registerReflectedClass("NeuroDef", "n", "com.framsticks.model.NeuroDef");
		registry.registerReflectedClass("Part", "p", "com.framsticks.model.Part");
		registry.registerReflectedClass("Model", "m", "com.framsticks.model.F0Genotype");
		registry.registerReflectedClass("F0Model", null, "com.framsticks.model.F0Model");
		registry.registerReflectedClass("F0Genotype", null, "com.framsticks.model.F0Genotype");
		registry.registerReflectedClass("Creature", null, "com.framsticks.model.Creature");
		registry.registerReflectedClass("Genotype", null, "com.framsticks.model.Genotype");

		registry.putInfoIntoCache(new FramsClass.Constructor(F0Model.class, "F0Model").getResult());
	}
}
