package com.framsticks.model;

import com.framsticks.util.Orientation;
import com.framsticks.util.Point3d;

/*
 */
public class MechPart extends BasePart {

	/** vol */
	public Double volume = 0.0;
	public Double getVol() { return volume; }
	public void setVol(Double vol) { volume = vol; }

	/** vx, vy, vz*/
	public double vx, vy, vz;

	public Point3d getVelocity() { return new Point3d(vx, vy, vz); }
	public void setVelocity(Point3d v) { vx = v.x; vy = v.y; vz = v.z; }

    public double oxx, oxy, oxz, oyx, oyy, oyz, ozx, ozy, ozz;

	public Orientation getOrientation() { return new Orientation(new Point3d(oxx, oxy, oxz), new Point3d(oyx, oyy, oyz), new Point3d(ozx, ozy, ozz)); }

	public void setOrientation(Orientation o) {
		oxx = o.x.x;
		oxy = o.x.y;
		oxz = o.x.z;
		oyx = o.y.x;
		oyy = o.y.y;
		oyz = o.y.z;
		ozx = o.z.x;
		ozy = o.z.y;
		ozz = o.z.z;
	}

}
