package com.framsticks.model;

import com.framsticks.params.FramsClass;
import com.framsticks.util.Orientation;

import java.util.ArrayList;
import java.util.List;

/**
 * Author: Piotr Śniegowski
 */
public class F0Model {

	public final List<MechPart> mechparts = new ArrayList<MechPart>();
	public final List<MechJoint> mechjoints = new ArrayList<MechJoint>();
	public final List<Neuro> neurons = new ArrayList<Neuro>();

	public final List<MechPart> getMechParts() { return mechparts; }
	public final List<MechJoint> getMechJoints() { return mechjoints; }
	public final List<Neuro> getNeurons() { return neurons; }

	public static void constructFramsClass(FramsClass.Constructor constructor) {
		constructor.field("mechparts");
		constructor.field("mechjoints");
		constructor.field("neurons");
	}

	public static F0Model build(F0Genotype f0Genotype) {
		F0Model model = new F0Model();

		for (Part p : f0Genotype.getParts()) {
			/** based on c++ Model::build*/
			MechPart mp = new MechPart();
			mp.setPosition(p.getPosition());
			mp.setOrientation(new Orientation().rotate(p.getRotation()));
			mp.copyFrom(p);
			model.mechparts.add(mp);
		}
		for (Joint j : f0Genotype.getJoints()) {
			/** based on c++ Joint::attachToParts*/
			MechPart mp1 = model.mechparts.get(j.getP1());
			MechPart mp2 = model.mechparts.get(j.getP2());
			assert mp1 != null && mp2 != null;
			MechJoint mj = new MechJoint();
			mj.copyFrom(j);
			Orientation o = new Orientation().rotate(j.getRotation());
			mp2.setOrientation(mp1.getOrientation().transform(o));
			mp2.setPosition(mp2.getOrientation().transform(j.getDelta()).add(mp1.getPosition()));
			model.mechjoints.add(mj);
		}
		for (NeuroDef nd : f0Genotype.getNeuroDefs()) {
			Neuro n = new Neuro();
			n.copyFrom(nd);
			model.neurons.add(n);
		}

		return model;
	}
}
