package com.framsticks.model;

import com.framsticks.util.Casting;
import com.framsticks.util.Containers;
import org.apache.log4j.Logger;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * Author: Piotr Śniegowski
 */
public class F0Genotype {

	private final static Logger LOGGER = Logger.getLogger(F0Genotype.class);

	public Double startingEnergy;
	public Double getEnerg0() { return startingEnergy; }
	public void setEnerg0(Double energ0) { startingEnergy = energ0; }

	public Double getSe() { return startingEnergy; }
	public void setSe(Double se) { startingEnergy = se; }

	/** Vstyle */
	public String visualizationStyle;
	public String getVstyle() { return visualizationStyle; }
	public void setVstyle(String Vstyle) { visualizationStyle = Vstyle; }

	public final List<Part> parts = new ArrayList<Part>();
	public final List<Joint> joints = new ArrayList<Joint>();
	public final List<NeuroDef> neurodefs = new ArrayList<NeuroDef>();

	public Double getNumparts() { return (double)parts.size(); }
	public Double getNumjoints() { return (double)joints.size(); }
	public Double getNumneurons() { return (double)neurodefs.size(); }

	//this is impossible to use, because numparts field is marked as readonly
	public void setNumparts(Double numparts) { Containers.resizeList(parts, (int) (double) numparts); }
	public void setNumjoints(Double numjoints) { Containers.resizeList(joints, (int)(double)numjoints); }
	public void setNumneurons(Double numneurons) { Containers.resizeList(neurodefs, (int)(double)numneurons); }

	public List<Part> getParts() { return parts; }
	public List<Joint> getJoints() { return joints; }
	public List<NeuroDef> getNeuroDefs() { return neurodefs; }

	public static F0Genotype build(List<Object> objects) {
		Iterator<Object> i = objects.iterator();
		if (!i.hasNext()) {
			return null;
		}
		F0Genotype f0Genotype = Casting.tryCast(F0Genotype.class, i.next());
		if (f0Genotype == null) {
			LOGGER.fatal("first object is not a Model");
			return null;
		}
		while (i.hasNext()) {
			Object object = i.next();
			if (object instanceof Joint) {
				f0Genotype.joints.add((Joint)object);
				continue;
			}
			if (object instanceof Part) {
				f0Genotype.parts.add((Part)object);
				continue;
			}
			if (object instanceof NeuroDef) {
				f0Genotype.neurodefs.add((NeuroDef) object);
				continue;
			}
			LOGGER.error("invalid class: " + object.getClass().getCanonicalName());
		}
		return f0Genotype;
	}
}
