package com.framsticks.model;

import com.framsticks.params.FramsClass;
import com.framsticks.util.Orientation;
import com.framsticks.util.Point3d;

import java.util.ArrayList;
import java.util.List;

public class Creature extends F0Model {
	public String name;

	public String genotype;

	public String info;

	public Object group;

	public Integer generation;
	public Integer getGnum() { return generation; }
	public void setGnum(Integer gnum) { generation = gnum; }

	public Integer buildProblems;
	public Integer getBuildproblems() { return buildProblems; }
	public void setBuildproblems(Integer buildproblems) { buildProblems = buildproblems; }

	public Double startingEnergy;
	public Double getEnerg0() { return startingEnergy; }
	public void setEnerg0(Double energ0) { startingEnergy = energ0; }

	public Double idlePowerConsumption;
	public Double getIdleen() { return idlePowerConsumption; }
	public void setIdleen(Double idleen) { idlePowerConsumption = idleen; }

	public Double energy;

	public Double energyIncome;
	public Double getEnergy_p() { return energyIncome; }
	public void setEnergy_p(Double energy_p) { energyIncome = energy_p; }

	public Double energyCosts;
	public Double getEnergy_m() { return energyCosts; }
	public void setEnergy_m(Double energy_m) { energyCosts = energy_m; }

	public Double energyBalance;
	public Double getEnergy_b() { return energyBalance; }
	public void setEnergy_b(Double energy_b) { energyBalance = energy_b; }

	public Integer performanceCalculation;
	public Integer getPerf() { return performanceCalculation; }
	public void setPerf(Integer perf) { performanceCalculation = perf; }

	public Boolean neuralNetworkEnabled;

	public Boolean getNnenabled() { return neuralNetworkEnabled; }
	public void setNnenabled(Boolean nnenabled) { neuralNetworkEnabled = nnenabled; }

	public Boolean bodySimulation;
	public Boolean getBodysim() { return bodySimulation; }
	public void setBodysim(Boolean bodysim) { bodySimulation = bodysim; }

	public Boolean selfCollisions;
	public Boolean getSelfcol() { return selfCollisions; }
	public void setSelfcol(Boolean selfcol) { selfCollisions = selfcol; }

	public Integer lifeSpan;
	public Integer getLifespan() { return lifeSpan; }
	public void setLifespan(Integer lifespan) { lifeSpan = lifespan; }

	public Double distance;

	public Double currentVelocity;
	public Double getC_velocity() { return currentVelocity; }
	public void setC_velocity(Double c_velocity) { currentVelocity = c_velocity; }

	public Double currentVerticalVelocity;
	public Double getC_vertvelocity() { return currentVerticalVelocity; }
	public void setC_vertvelocity(Double c_vertvelocity) { currentVerticalVelocity = c_vertvelocity; }

	public Double currentVerticalPosition;
	public Double getC_vertpos() { return currentVerticalPosition; }
	public void setC_vertpos(Double c_vertpos) { currentVerticalPosition = c_vertpos; }

	public Double averageVelocity;
	public Double getVelocity() { return averageVelocity; }
	public void setVelocity(Double c_velocity) { averageVelocity = c_velocity; }

	public Double averageVerticalVelocity;
	public Double getVertvel() { return averageVerticalVelocity; }
	public void setVertvel(Double c_vertvelocity) { averageVerticalVelocity = c_vertvelocity; }

	public Double averageVerticalPosition;
	public Double getVertpos() { return averageVerticalPosition; }
	public void setVertpos(Double c_vertpos) { averageVerticalPosition = c_vertpos; }

	/** pos_x, pos_y, pos_z*/
	public double pos_x, pos_y, pos_z;

	public Point3d getPosition() { return new Point3d(pos_x, pos_y, pos_z) ; }
	public void setPosition(Point3d pos) { pos_x = pos.x; pos_y = pos.y; pos_z = pos.z; }

	public double size_x, size_y, size_z;

	public Point3d getBoundingBox() { return new Point3d(size_x, size_y, size_z) ; }
	public void setBoundingBox(Point3d size) { size_x = size.x; size_y = size.y; size_z = size.z; }


	/** center_x, center_y, center_z*/
	public double center_x, center_y, center_z;

	public Point3d getCenter() { return new Point3d(center_x, center_y, center_z) ; }
	public void setCenter(Point3d center) { center_x = center.x; center_y = center.y; center_z = center.z; }

	public Integer getNumparts() { return parts.size(); }
	public void setNumparts(Integer numparts) { }

	public Integer getNumjoints() { return joints.size(); }
	public void setNumjoints(Integer numjoints) { }

	public Integer getNumneurons() { return neurons.size(); }
	public void setNumneurons(Integer numneurons) { }

	public Object[] userFields = new Object[3];
	public Object getUser1() { return userFields[0]; }
	public void setUser1(Object user1) { userFields[0] = user1; }

	public Object getUser2() { return userFields[1]; }
	public void setUser2(Object user2) { userFields[1] = user2; }

	public Object getUser3() { return userFields[2]; }
	public void setUser3(Object user3) { userFields[2] = user3; }

	public Integer selfCollisionMask;
	public Integer getSelfmask() { return selfCollisionMask; }
	public void setSelfmask(Integer selfmask) { selfCollisionMask = selfmask; }

	public Integer otherCollisionMask;
	public Integer getOthermask() { return otherCollisionMask; }
	public void setOthermask(Integer othermask) { otherCollisionMask = othermask; }

	public String uid;

	public Integer index;

	public final List<Part> parts = new ArrayList<Part>();
	public final List<Joint> joints = new ArrayList<Joint>();
	public final List<NeuroDef> neurodefs = new ArrayList<NeuroDef>();



	public final List<Part> getParts() { return parts; }
	public final List<Joint> getJoints() { return joints; }
	public final List<NeuroDef> getNeuroDefs() { return neurodefs; }



	public static void constructFramsClass(FramsClass.Constructor constructor) {
		constructor.field("name");
		constructor.field("parts");
		constructor.field("joints");
		constructor.field("neurodefs");
	}

}
