package com.framsticks.model;

import com.framsticks.util.Point3d;

/**
 * Author: Piotr Śniegowski
 */
public class BasePart {
	/** x, y, z */
	public double x, y, z;

	public Point3d getPosition() { return new Point3d(x, y, z); }
	public void setPosition(Point3d p) { x = p.x; y = p.y; z = p.z; }

	/** m */
	public Double mass = 0.0;
	public Double getM() { return mass; }
	public void setM(Double m) { mass = m; }

	/** s */
	public Double size = 0.0;
	public Double getS() { return size; }
	public void setS(Double s) { size = s; }

	/** fr */
	public Double friction;
	public Double getFr() { return friction; }
	public void setFr(Double fr) { friction = fr; }


	public void copyFrom(BasePart p) {
		setPosition(p.getPosition());
		mass = p.mass;
		size = p.size;
		friction = p.friction;
	}
}
