package com.framsticks.model;

import com.framsticks.util.Point3d;

/**
 * Author: Piotr Śniegowski
 */
public class BaseJoint {

	/** stif */
	public Double stiffness;
	public Double getStif() { return stiffness; }
	public void setStif(Double stif) { stiffness = stif; }

	/** rotstif */
	public Double rotationStiffness;
	public Double getRotstif() { return rotationStiffness; }
	public void setRotstif(Double rotstif) { rotationStiffness = rotstif; }

	/** rx, ry, rz*/
	public double rx, ry, rz;

	public Point3d getRotation() { return new Point3d(rx, ry, rz); }
	public void setRotation(Point3d r) { rx = r.x; ry = r.y; rz = r.z; }

	/** dx, dy, dz*/
	public double dx, dy, dz;

	public Point3d getDelta() { return new Point3d(dx, dy, dz); }
	public void setDelta(Point3d d) { dx = d.x; dy = d.y; dz = d.z; }

	public void copyFrom(BaseJoint j) {
		stiffness = j.stiffness;
		rotationStiffness = j.rotationStiffness;
		setRotation(j.getRotation());
		setDelta(j.getDelta());
	}
}
