package com.framsticks.hosting;

import com.framsticks.core.*;
import com.framsticks.params.FramsClass;
import com.framsticks.params.ParamBuilder;
import com.framsticks.params.types.CompositeParam;
import com.framsticks.core.LocalInstance;
import com.framsticks.util.Future;
import org.apache.log4j.Logger;

/**
 * @author Piotr Sniegowski
 */
public class ServerInstance extends LocalInstance {

    private final static Logger LOGGER = Logger.getLogger(ServerInstance.class.getName());

    Entity hosted;

    public ServerInstance(Parameters parameters) {
        super(parameters);
    }

    @Override
    protected void run() {
        super.run();
        assert hosted != null;
        hosted.start();
    }

    @Override
    protected void configure() throws Exception {
        super.configure();

        Parameters p = new Parameters(config.subset("hosted.entity"), "hosted", this, null);
        hosted = Program.configureEntity(p);
        if (hosted == null) {
            LOGGER.fatal("failed to create hosted entity");
            return;
        }
        hosted.configurePublic();
        root = new Node((CompositeParam)new ParamBuilder().setName("root").setId("root").setType("o" + hosted.getClass().getCanonicalName()).build(), hosted);
    }

    @Override
    public FramsClass getInfoFromCache(String id) {
        assert isActive();
        if (id == null) {
            return null;
        }
		FramsClass cached = registry.getInfoFromCache(id);
        if (cached != null) {
			return cached;
        }
        try {
            Class nativeClass = Class.forName(id);
            FramsClass framsClass = new FramsClass.Constructor(nativeClass, id).getResult();

            registry.registerReflectedClass(null, id, nativeClass);
            registry.putInfoIntoCache(framsClass);
            return framsClass;
        } catch (ClassNotFoundException ignored) {
        }

        return null;
    }

    @Override
    protected void fetchInfo(Path path, Future<FramsClass> future) {
        assert isActive();

        FramsClass framsClass = getInfoFromCache(path.getTop().getObject().getClass().getCanonicalName());
        if (framsClass == null) {
            LOGGER.error("failed to create frams class for: " + path.getTop().getObject().getClass());
            future.result(null, new Exception());
            return;
        }
        future.result(framsClass, null);

    }

    @Override
    protected void tryRegisterOnChangeEvents(Path path) {
    }

}
