package com.framsticks.gui;

import com.framsticks.core.*;
import com.framsticks.observers.Endpoint;
import com.framsticks.observers.Observer;
import com.framsticks.util.Dispatcher;
import org.apache.log4j.Logger;

import javax.swing.*;
import java.util.HashSet;
import java.util.Set;

/**
 * @author Piotr Sniegowski
 */
public class Browser extends Observer implements Dispatcher {

    private static final Logger LOGGER = Logger.getLogger(Browser.class.getName());

    protected final Set<Frame> frames = new HashSet<Frame>();
    protected MainFrame mainFrame;

    public void addFrame(Frame frame) {
        frames.add(frame);
    }

	public Browser(Parameters parameters) {
        super(parameters);
        dispatcher = SwingDispatcher.instance;
        invokeLater(new Runnable() {
            @Override
            public void run() {
                assert isActive();

            }
        });
	}

	public void clear() {
        assert isActive();
        for (Frame f : frames) {
            f.clear();
        }
	}

    @Override
    protected void configure() throws Exception {
        super.configure();
    }


    @Override
    public void run() {
        super.run();

        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
        } catch (Exception ex) {
            LOGGER.warn("failed loading Look&Feel: ", ex);
        }
        javax.swing.JFrame.setDefaultLookAndFeelDecorated(true);

        mainFrame = new MainFrame(Browser.this);
        addFrame(mainFrame);

        for (Frame f : frames) {
            f.configure();
        }

        for (final Endpoint e : getEndpoints().values()) {
            e.invokeLater(new Runnable() {
                @Override
                public void run() {
                    final Path p = new Path(e.getInstance(), "/");
                    invokeLater(new Runnable() {
                        @Override
                        public void run() {
                            mainFrame.addRootPath((BrowserEndpoint) e, p);
                        }
                    });
                }
            });

        }

        for (Frame f : frames) {
            f.setVisible(true);
        }
    }

    public void createTreeNodeForChild(final Path path) {
        assert !isActive();
        //assert instance.isActive();


/*
        final TreeNode parentTreeNode = (TreeNode) child.getParent().getUserObject();
        if (parentTreeNode == null) {
            Dispatching.invokeDispatch(this, manager, new Runnable() {
                @Override
                public void run() {
                    createTreeNodeForChild(child);
                }
            });
            return;
        }
        LOGGER.debug(child.getClass().getSimpleName() + " created: " + child);


        invokeLater(new Runnable() {
            @Override
            public void run() {
                parentTreeNode.getOrCreateChildTreeNodeFor(child);
            }
        });
*/
	}


    @Override
    protected Endpoint createEndpoint() {
        return new BrowserEndpoint();
    }

}
