package com.framsticks.examples;

import com.framsticks.core.Instance;
import com.framsticks.core.Node;
import com.framsticks.core.Parameters;
import com.framsticks.core.Path;
import com.framsticks.model.*;
import com.framsticks.model.Package;
import com.framsticks.params.*;
import com.framsticks.params.types.CompositeParam;
import com.framsticks.parsers.F0Parser;
import com.framsticks.parsers.Schema;
import org.apache.log4j.Logger;

import java.util.List;

/**
 * Author: Piotr Śniegowski
 */
public class GenotypeBrowser extends Instance {

	private static final Logger LOGGER = Logger.getLogger(Instance.class.getName());
	protected Schema schema;


	public GenotypeBrowser(Parameters parameters) {
		super(parameters);
		LOGGER.info("model builder created");
	}

	@Override
	protected void configure() throws Exception {
		super.configure();
		schema = new Schema(Schema.getDefaultDefinitionAsStream());
		this.registry = schema.getRegistry();
		Package.register(this.getRegistry());

		registry.putInfoIntoCache(new FramsClass("ModelBuilderRoot", "ModelBuilderRoot", null)
				.append(new ParamBuilder().setType("o Model").setId("f0genotype").setName("f0genotype").build())
				.append(new ParamBuilder().setType("o F0Model").setId("f0model").setName("f0model").build())
		);
		root = new Node((CompositeParam)new ParamBuilder().setType("o ModelBuilderRoot").setId(name).setName("Instance").build(), PropertiesAccess.createPropertiesMap());
	}

	@Override
	protected void run() {
		assert isActive();

		try {
			List<AccessInterface> accesses = new F0Parser(schema, GenotypeBrowser.class.getResourceAsStream("/examples/f0_example.txt")).parse();
			List<Object> objects = Util.stripAccessInterface(accesses);
			F0Genotype f0Genotype = F0Genotype.build(objects);
			F0Model f0Model = F0Model.build(f0Genotype);

			for (String n : new String[] {"MechPart", "MechJoint", "Neuro"}) {
				registry.putInfoIntoCache(FramsClass.readFromStream(GenotypeBrowser.class.getResourceAsStream("/info/" + n + ".info")));
			}
			AccessInterface rootAccess = bindAccess(new Path(this, "/"));

			rootAccess.set("f0genotype", f0Genotype);
			rootAccess.set("f0model", f0Model);

		} catch (Exception e) {
			LOGGER.error("exception caught: " + e);
		}
		//done();
	}

}
