package com.framsticks.dumping;

import com.framsticks.core.LocalInstance;
import com.framsticks.core.Parameters;
import com.framsticks.core.Path;
import com.framsticks.params.FramsClass;
import com.framsticks.core.Instance;
import com.framsticks.util.*;
import com.framsticks.util.UnsupportedOperationException;
import org.apache.log4j.Logger;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

/**
 * @author Piotr Sniegowski
 */
public class FileInstance extends LocalInstance {

    private static final Logger LOGGER = Logger.getLogger(Instance.class.getName());
    protected final File file;

    public FileInstance(Parameters parameters) {
        super(parameters);
        file = new File(config.getString("filename"));
    }

    @Override
    public void run() {
        assert isActive();
        super.run();
        try {
            FileReader fileReader = new FileReader(file);
            LoadStream stream = new LoadStream(new Path(this, "/"), new BufferedReader(fileReader), this, new Future<Path>() {
                @Override
                public void result(Path result, Exception e) {
                    if (e != null) {
                        LOGGER.error("failed to load file instance " + FileInstance.this + ": " + e);
                        fireRun(e);
                        return;
                    }
                    LOGGER.info("loaded file instance " + FileInstance.this);
                    fireRun(null);
                }
            });
            stream.load();
        } catch (IOException e) {
            LOGGER.error("io failure: " + e);
            fireRun(e);
        }
    }

    @Override
    public String toString() {
        return "file@" + file.getName();
    }



}
