package com.framsticks.diagnostics;

import com.framsticks.core.Parameters;
import com.framsticks.observers.Endpoint;
import com.framsticks.observers.Observer;

/**
 * @author Piotr Sniegowski
 */
public class Diagnostics extends Observer {

    final Integer dumpsInterval;
    final String dumpsPath;
    final String dumpsFormat;


    public Diagnostics(Parameters parameters) {
        super(parameters);
        dumpsInterval = config.getInteger("dumps.interval", null);
        dumpsPath = config.getString("dumps.path", null);
        dumpsFormat = config.getString("dumps.format", null);
    }

    @Override
    protected void configure() throws Exception {

        super.configure();
    }


    @Override
    protected Endpoint createEndpoint() {
        return new DiagnosticsEndpoint();
    }


}
