package com.framsticks.core;

import com.framsticks.util.Pair;
import com.framsticks.util.Strings;
import org.apache.commons.configuration.*;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
//import sun.misc.Signal;
//import sun.misc.SignalHandler;

import java.lang.reflect.Constructor;
import java.util.*;

/**
 * @author Piotr Sniegowski
 */
public class Program extends com.framsticks.util.Thread {

    private final static Logger LOGGER = Logger.getLogger(Program.class.getName());

/*
    protected SignalHandler signalHandler = new SignalHandler() {
        @Override
        public void handle(Signal signal) {
            LOGGER.info("caught " + signal);
            Runtime.getRuntime().exit(0);
        }
    };
*/

    protected Entity entity;

    Configuration config;


    public Program(String name) {
        super(name, java.lang.Thread.currentThread());
//        Signal.handle(new Signal("INT"), signalHandler);
//        Signal.handle(new Signal("TERM"), signalHandler);
    }

    public static Entity configureEntity(Parameters parameters) {
        String typeName = parameters.getConfig().getString("class");
        LOGGER.info("configuring instance " + typeName);
        try {
            Class type = Class.forName(typeName);
            Constructor constructor = type.getConstructor(Parameters.class);
            return (Entity) constructor.newInstance(parameters);
        } catch (Exception e) {
            LOGGER.error("failed to instantiate: " + e);
        }
        return null;
    }

    protected static void resolve(Configuration config, String prefix) {

        Iterator i = prefix == null ? config.getKeys() : config.getKeys(prefix);
        while (i.hasNext()) {
            String p = (String) i.next();
            if (p.endsWith(".mount")) {
                String source = config.getString(p);
                LOGGER.info("mounting " + source + " at " + p);
                config.clearProperty(p);
                Configuration mount = config.subset(source);
                Iterator mi = mount.getKeys();
                while (mi.hasNext()) {
                    String mk = (String) mi.next();
                    config.addProperty(p.substring(0, p.length() - 6) + "." + mk, mount.getProperty(mk));
                }
            }
        }
    }

    public void run(String[] args) {

		PropertyConfigurator.configure(getClass().getResource("/configs/log4j.properties"));
		LOGGER.debug("started in " + System.getProperty("user.dir"));
        try {
			config = new PropertiesConfiguration(getClass().getResource("/configs/framsticks.properties"));

            for (String a : args) {
                Pair<String, String> p = Strings.splitIntoPair(a, '=', "true");
                config.setProperty(p.first, p.second);
            }

            resolve(config, null);

            Iterator i = config.getKeys();
            while (i.hasNext()) {
                String p = (String) i.next();
                LOGGER.debug(p + " = " + config.getProperty(p));
            }

        } catch (ConfigurationException e) {
            System.err.print("failed to parse configuration:" + e);
            return;
        }

        entity = configureEntity(new Parameters(config.subset("com.framsticks.entity"), "main", null, new EntityOwner() {
			@Override
			public void onDone() {
				LOGGER.info("exiting");
				Runtime.getRuntime().exit(0);
			}
		}));
		try {
	        entity.configurePublic();
		} catch (Exception e) {
			LOGGER.fatal("exception caught during configuration: " + e);
		}
        LOGGER.info("all entities were configured");
        entity.start();
    }

    public static void main(final String[] args) {
        final Program program = new Program("program");
        program.invokeLater(new Runnable() {
            @Override
            public void run() {
                program.run(args);
            }
        });
        program.routine();
    }

}
