package com.framsticks.core;

import com.framsticks.params.FramsClass;
import com.framsticks.util.Dispatcher;
import org.apache.commons.configuration.Configuration;

/**
 * @author Piotr Sniegowski
 */
public class Parameters {
    protected Configuration config;
    protected String name;
    protected Dispatcher dispatcher;
	protected EntityOwner owner;



    public Parameters(Configuration config, String name, Dispatcher dispatcher, EntityOwner owner) {
        this.config = config;
        this.name = name;
        this.dispatcher = dispatcher;
		this.owner = owner;
    }

    public Parameters(Parameters parameters) {
        config = parameters.config;
        name = parameters.name;
        dispatcher = parameters.dispatcher;
		owner = parameters.owner;
    }

    public final Configuration getConfig() {
        return config;
    }

    public final String getName() {
        return name;
    }

    public static void constructFramsClass(FramsClass.Constructor constructor) {
        constructor.method("getName");
    }
}
