package com.framsticks.core;

import com.framsticks.hosting.InstanceClient;
import com.framsticks.params.AccessInterface;
import com.framsticks.params.Param;
import com.framsticks.util.*;
import com.framsticks.util.Thread;
import org.apache.log4j.Logger;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashSet;
import java.util.Set;


/**
 * @author Piotr Sniegowski
 */
public abstract class LocalInstance extends Instance {

    private static final Logger LOGGER = Logger.getLogger(LocalInstance.class.getName());

    public LocalInstance(Parameters parameters) {
        super(parameters);

        Integer accept = config.getInteger("accept", null);
        if (accept != null) {
            try {
                acceptSocket = new ServerSocket();
                acceptSocket.setReuseAddress(true);
                acceptThread = new Thread(name + "-accept");
                tryBind(accept);
            } catch (IOException e) {
                LOGGER.fatal("failed to create accept socket: " + e);
            }
        }
    }

    @Override
    protected void run() {
        super.run();
    }

    @Override
    protected void configure() throws Exception {
        super.configure();
    }

    protected final Set<InstanceClient> clients = new HashSet<InstanceClient>();
    ServerSocket acceptSocket;
    Thread acceptThread;

    protected void acceptNext() {
        acceptThread.invokeLater(new Runnable() {
            @Override
            public void run() {
                try {
                    final Socket socket = acceptSocket.accept();
                    assert socket != null;
                    LOGGER.debug("accepted socket: " + socket.getInetAddress().getHostAddress());
                    invokeLater(new Runnable() {
                        @Override
                        public void run() {
                            InstanceClient client = new InstanceClient(LocalInstance.this, socket);
                            clients.add(client);
                            LOGGER.info("client connected: " + client);
                        }
                    });
                } catch (IOException e) {
                    LOGGER.error("failed to accept socket: " + e);
                }
                acceptNext();
            }
        });
    }

    public void tryBind(final Integer accept) {
        acceptThread.invokeLater(new Runnable() {
            @Override
            public void run() {
                try {
                    acceptSocket.bind(new InetSocketAddress(accept));
                    LOGGER.debug("started accepting on port " + accept);
                    acceptNext();
                } catch (IOException e) {
                    LOGGER.fatal("failed to accept on port " + accept + ": " + e);
                }
                try {
                    java.lang.Thread.sleep(1000);
                } catch (InterruptedException ignored) {
                }
                tryBind(accept);
            }
        });
    }

}
