package com.framsticks.core;

import com.framsticks.util.*;
import com.framsticks.util.Thread;
import org.apache.log4j.Logger;

/**
 * @author Piotr Sniegowski
 */
public abstract class Entity extends Parameters implements Dispatcher {

    private final static Logger LOGGER = Logger.getLogger(Entity.class.getName());

    public Entity(Parameters parameters) {
        super(parameters);
        if (dispatcher == null) {
            dispatcher = new Thread(name);
        }
    }

    @Override
    public final boolean isActive() {
        return dispatcher.isActive();
    }

    @Override
    public final void invokeLater(Runnable runnable) {
        dispatcher.invokeLater(runnable);
    }

    protected void run() {
        assert isActive();
        LOGGER.info("running: " + this);
    }

    public final void configurePublic() throws Exception {
        configure();
    }

    protected void configure() throws Exception {

    }

    public Dispatcher getDispatcher() {
        return dispatcher;
    }

    public final void start() {
        invokeLater(new Runnable() {
            @Override
            public void run() {
                Entity.this.run();
            }
        });
    }

	public final void done() {
		LOGGER.info("stopping entity");
		if (owner != null) {
			owner.onDone();
		}
	}


}
